(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     37556,       1106]*)
(*NotebookOutlinePosition[     39019,       1150]*)
(*  CellTagsIndexPosition[     38949,       1144]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
M\[EAcute]todo de Newton para ra\[IAcute]ces complejas.
Conjuntos de Julia y de Mandelbrot\
\>", "Title"],

Cell[TextData[{
  "\nUniversidad de Granada\nDepartamento de An\[AAcute]lisis \
Matem\[AAcute]tico\nFco. Javier P\[EAcute]rez Gonz\[AAcute]lez  ",
  ButtonBox[" fjperez@ugr.es\n",
    ButtonData:>{
      URL[ "mailto:fjperez@ugr.es"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  PageBreakBelow->False,
  TextAlignment->Right,
  LineSpacing->{0.4, 0},
  FontSize->12],

Cell[CellGroupData[{

Cell["Aproximaci\[OAcute]n de ra\[IAcute]ces complejas por el m\[EAcute]todo \
de Newton", "Section"],

Cell[TextData[{
  "Como seguramente ya sabes, el m\[EAcute]todo de Newton es una \
t\[EAcute]cnica frecuentemente usada para calcular soluciones de una ecuaci\
\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(z) = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Para ello, se elige un valor inicial ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_1\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y, a partir de \[EAcute]l, se forma la sucesi\[OAcute]n definida por",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{\(z\_\(n + 1\)\), "=", 
          RowBox[{\(z\_n\), "-", 
            StyleBox[\(\(f(z\_n)\)\/\(f\ ' \((z\_n)\)\)\),
              FontSize->16]}]}], TraditionalForm]],
    FontWeight->"Bold"],
  ". Si dicha sucesi\[OAcute]n converge, su l\[IAcute]mite es una soluci\
\[OAcute]n de la ",
  "ecuaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(z) = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  ".",
  " Naturalmente, cuando hay m\[AAcute]s de una soluci\[OAcute]n, la elecci\
\[OAcute]n del valor inicial determina a cu\[AAcute]l de ellas converge el \
proceso. \n",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando \"FindRoot[f(z)=0,{z,a}]\" que utiliza precisamente el m\
\[EAcute]todo de Newton para calcular soluciones de  la ",
  "ecuaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(z) = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  " a partir del valor inicial ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z = a\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Eval\[UAcute]a la siguiente celda."
}], "Text"],

Cell[BoxData[
    \(FindRoot[z\^2 + 1 \[Equal] 0, {z, 0.5}]\)], "Input"],

Cell[TextData[{
  "\[DownQuestion]Sabes por qu\[EAcute] ha fallado el m\[EAcute]todo en este \
caso particular? F\[IAcute]jate en c\[OAcute]mo se van obteniendo las \
aproximaciones sucesivas ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(z\_\(n + 1\)\), "=", 
          RowBox[{\(z\_n\), "-", 
            StyleBox[\(\(f(z\_n)\)\/\(f\ ' \((z\_n)\)\)\),
              FontSize->16]}]}], TraditionalForm]],
    FontWeight->"Bold"],
  ". Es evidente que, para ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(f \((z)\)\),
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox[\(z\^2\),
              FontWeight->"Bold"], 
            StyleBox["+",
              FontWeight->"Bold"], 
            StyleBox["1",
              FontWeight->"Bold"], " "}]}], TraditionalForm]]],
  "partiendo de un valor real obtenemos siempre valores reales por lo que el \
m\[EAcute]todo no puede proporcionarnos las ra\[IAcute]ces de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\^2 + 1\  = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  " que son complejas. Repite con una ligera variante."
}], "Text"],

Cell[BoxData[
    \(FindRoot[z\^2 + 1 \[Equal] 0, {z, 0.5 + 0.1  \[ImaginaryI]}]\)], "Input"],

Cell[TextData[{
  "Ahora ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha calculado la soluci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z = \[ImaginaryI]\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "con gran precisi\[OAcute]n. Observa ahora el efecto de cambiar un poco el \
valor inicial."
}], "Text"],

Cell[BoxData[
    \(FindRoot[z\^2 + 1 \[Equal] 0, {z, 0.5 - 0.1  \[ImaginaryI]}]\)], "Input"],

Cell["\<\
Si quieres, puedes ver las sucesivas aproximaciones y los correspondientes \
valores de la funci\[OAcute]n.\
\>", "Text"],

Cell[BoxData[{
    \(\(z[0] = 0.5 + 0.1  \[ImaginaryI];\)\), "\[IndentingNewLine]", 
    \(\(z[n_] := \(z[n] = 
          z[n - 1] - \(z[n - 1]\^2 + 1\)\/\(2\ z[n - 1]\)\);\)\), "\
\[IndentingNewLine]", 
    \(\(Print[
        TableForm[Table[{k, z[k], z[k]\^2 + 1}, {k, 0, 7}], 
          TableHeadings \[Rule] {None, {"\<k\>", "\<z[k]\>", \
\*"\"\<z[k\!\(\(]\^2\)\)+1\>\""}}]];\)\)}], "Input"],

Cell[TextData[{
  "Como puedes ver ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " aplica el m\[EAcute]todo de Newton para calcular ra\[IAcute]ces tanto \
reales como complejas. Ahora bien, la intrepretaci\[OAcute]n del \
m\[EAcute]todo en el caso del c\[AAcute]lculo de ra\[IAcute]ces reales no \
tiene sentido en el caso complejo. En el caso real, el punto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_\(n + 1\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "se obtiene como el punto de corte de la recta tangente a la curva ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = f(z)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " en el punto",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\((z\_n, f(z\_n))\)\)],
    FontWeight->"Bold"],
  " con el eje de abscisas y se conocen condiciones precisas que garantizan \
la convergencia del m\[EAcute]todo. Lo que ocurre en el caso complejo puede \
ser ",
  StyleBox["mucho m\[AAcute]s complicado",
    FontSlant->"Italic"],
  " como vamos a ver. "
}], "Text"],

Cell[TextData[{
  "A continuaci\[OAcute]n vamos a aplicar el m\[EAcute]todo de Newton para \
calcular aproximaciones de las ra\[IAcute]ces del polinomio ",
  Cell[BoxData[
      \(TraditionalForm\`z\^3 + 1\)],
    FontWeight->"Bold"],
  ". Pid\[AAcute]mosle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que calcule dichas ra\[IAcute]ces."
}], "Text"],

Cell[BoxData[
    \(raices = 
      z /. \((Solve[z\^3 + 1 \[Equal] 0, 
              z] /. \((a_ -> b_)\) :> \((a -> 
                  ComplexExpand[b])\))\)\)], "Input"],

Cell["Sus aproximaciones num\[EAcute]ricas son", "Text"],

Cell[BoxData[
    \(raices // N\)], "Input"],

Cell[TextData[{
  "Observa que si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(z) = z\^3 + 1\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "entonces  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"z", "-", 
            FormBox[
              StyleBox[\(\(f(z)\)\/\(f\ ' \((z)\)\)\),
                FontSize->16],
              "TraditionalForm"]}], "=", 
          StyleBox[\(\(\(-1\) + 2\ z\^3\)\/\(3\ z\^2\)\),
            FontSize->16]}], TraditionalForm]],
    FontWeight->"Bold"],
  ".  La siguiente funci\[OAcute]n \"NewtonAprox\" le dice a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que, partiendo de un valor inicial ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(z = x + \[ImaginaryI]\ y\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  StyleBox[", ",
    FontWeight->"Bold"],
  "calcule las sucesivas iteraciones del m\[EAcute]todo de Newton para \
aproximar una soluci\[OAcute]n de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\^3 + 1 = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y que se pare si en alg\[UAcute]n paso el valor obtenido de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(z\)\(\ \ \)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "verifica que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(z\^3 + 1\)\(|\)\(\(\[LessEqual]\)\(0.001\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " o si ha llegado a la iteraci\[OAcute]n n\[UAcute]mero cincuenta. Tambi\
\[EAcute]n le pedimos que imprima el \[UAcute]ltimo valor obtenido de ",
  StyleBox["z ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "La funci\[OAcute]n est\[AAcute] escrita haciendo uso de la opci\[OAcute]n \
\"Compile\" para que se ejecute m\[AAcute]s r\[AAcute]pidamente."
}], "Text"],

Cell[BoxData[
    \(\(NewtonAprox = 
        Compile[{{z, _Complex}}, 
          Module[{w, k = 0}, 
            w = z; \[IndentingNewLine]While[
              Abs[w\^3 + 1] > 0.001\  && \ k \[LessEqual] 50\  && \ 
                w \[NotEqual] 0, w = \(\(-1\) + 2  w\^3\)\/\(3\ w\^2\); 
              k = k + 1]; w]];\)\)], "Input"],

Cell["\<\
Comprueba lo r\[AAcute]pido que trabaja esta funci\[OAcute]n evaluando la \
siguiente celda.\
\>", "Text"],

Cell[BoxData[
    \(Table[
        NewtonAprox[x + y\ I], {y, \(-2\), 2,  .6}, {x, \(-2\), 2, 1.25}] // 
      MatrixForm\)], "Input"],

Cell[TextData[{
  "Observa c\[OAcute]mo se obtiene una u otra ra\[IAcute]z dependiendo del \
punto de partida. Lo que vamos a hacer ahora es asignarle a cada punto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z = x + \[ImaginaryI]\ y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " un valor distinto seg\[UAcute]n cu\[AAcute]l sea la ra\[IAcute]z a la que \
converja el algoritmo anterior cuando se toma  como valor inicial dicho \
punto. Concretamente, si la ra\[IAcute]z a la que converge el m\[EAcute]todo \
es",
  StyleBox[" -1",
    FontWeight->"Bold"],
  " le damos a ",
  StyleBox["z",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " el valor",
  StyleBox[" 0.15",
    FontWeight->"Bold"],
  ", si es ",
  StyleBox["0.5 + 0.866 \[ImaginaryI] ",
    FontWeight->"Bold"],
  "le damos el valor ",
  StyleBox["0.5",
    FontWeight->"Bold"],
  " y si es ",
  StyleBox["0.5 - 0.866 \[ImaginaryI] ",
    FontWeight->"Bold"],
  "le damos el valor ",
  StyleBox["0.9",
    FontWeight->"Bold"],
  ". La raz\[OAcute]n de estos valores es que vamos a usarlos despu\[EAcute]s \
para aplicarles la funci\[OAcute]n de color \"Hue\". El color Hue[0.15] es \
amarillo, el Hue[0.5] es azul y el Hue[0.9] es rojo. Necesitamos redefinir la \
funci\[OAcute]n \"NewtonAprox\". Procura entender lo que sigue."
}], "Text"],

Cell[BoxData[
    \(\(NewtonColorAprox = 
        Compile[{{z, _Complex}}, \[IndentingNewLine]Module[{w, k = 0}, 
            w = z; \[IndentingNewLine]While[
              Abs[w\^3 + 1] > 0.001\  && \ k \[LessEqual] 50\  && \ 
                w \[NotEqual] 0, w = \(\(-1\) + 2\ w\^3\)\/\(3\ w\^2\); 
              k = k + 1]; \[IndentingNewLine]Which[
              Abs[w - \((\(-1\))\)] < 0.1, 0.15, 
              Abs[w - \((0.5\[InvisibleSpace] + 0.866\ \[ImaginaryI])\)] < 
                0.1, 0.5, \[IndentingNewLine]Abs[
                  w - \((0.5\[InvisibleSpace] - 0.866\ \[ImaginaryI])\)] < 
                0.1, 0.9, w \[Equal] 0, 0.9]]\ ];\)\)], "Input"],

Cell[TextData[{
  "Ahora la funci\[OAcute]n \"NewtonColorAprox\" ya no proporciona el \
\[UAcute]tlimo valor de ",
  StyleBox["z",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "calculado sino el valor asignado a ",
  StyleBox["z",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " seg\[UAcute]n el criterio anterior. Como \"NewtonColorAprox\" da siempre \
como resultado un n\[UAcute]mero complejo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a + \(\(b\)\(\ \)\(\[ImaginaryI]\)\(\ \)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", e incluso si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(b = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  " escribe ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a + 0  i\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", nos quedamos con la parte real."
}], "Text"],

Cell[BoxData[
    \(Table[
        Re[NewtonColorAprox[x + y\ I]], {y, \(-2\), 2,  .6}, {x, \(-2\), 2, 
          1.25}] // MatrixForm\)], "Input"],

Cell[TextData[{
  "Lo que vamos a hacer ahora puede describirse ",
  StyleBox["m\[AAcute]s o menos",
    FontSlant->"Italic"],
  " como sigue. Dividiremos cada lado del cuadrado [-2,2]\[Times][-2,2] en \
500 partes, obtendremos as\[IAcute] 500\[Times]500=250.000 cuadraditos. En \
cada uno de ellos tomamos un punto (x,y) y evaluamos en dicho punto nuestra \
funci\[OAcute]n \"NewtonColorAprox\". Obtenemos as\[IAcute] una matriz de 500 \
filas y 500 columnas a la que aplicamos la funci\[OAcute]n de color \"Hue\". \
De esta forma, los puntos que convergen a la ra\[IAcute]z ",
  StyleBox["-1",
    FontWeight->"Bold"],
  " se colorean de amarillo, los que convergen a la ra\[IAcute]z ",
  Cell[BoxData[
      StyleBox[\(1\/2 + \(\[ImaginaryI]\ \@3\)\/2\),
        FontWeight->"Bold"]]],
  "se colorean de azul y los que convergen a la ra\[IAcute]z ",
  Cell[BoxData[
      StyleBox[\(1\/2 - \(\[ImaginaryI]\ \@3\)\/2\),
        FontWeight->"Bold"]]],
  "se colorean de rojo. Ten paciencia porque todo el proceso tarda unos 4 \
minutos pero merece la pena esperar. "
}], "Text"],

Cell[BoxData[
    \(\(DensityPlot[
        NewtonColorAprox[x + y\ I], {x, \(-2\), 2. }, \ {y, \(-2\), 2}, 
        PlotPoints \[Rule] 500, Mesh \[Rule] False, AspectRatio \[Rule] 1, 
        ColorFunction \[Rule] Hue];\)\)], "Input"],

Cell["Veamos ampliada la hoja superior del tr\[EAcute]bol central.", "Text"],

Cell[BoxData[
    \(\(DensityPlot[
        NewtonColorAprox[x + y\ I], {x, \(- .6\), 0.01}, \ {y, 0.01,  .8}, 
        PlotPoints \[Rule] 200, Mesh \[Rule] False, AspectRatio \[Rule] 1, 
        ColorFunction \[Rule] Hue];\)\)], "Input"],

Cell["\<\
Hagamos ahora una ampliaci\[OAcute]n de la hoja superior del tr\[EAcute]bol \
que hay a la derecha.\
\>", "Text"],

Cell[BoxData[
    \(\(DensityPlot[
        NewtonColorAprox[x + y\ I], {x, \(- .154\), \(-0.088\)}, \ {y, 
          0.55,  .7}, PlotPoints \[Rule] 200, Mesh \[Rule] False, 
        AspectRatio \[Rule] 1, ColorFunction \[Rule] Hue];\)\)], "Input"],

Cell[TextData[{
  "As\[IAcute] podr\[IAcute]amos seguir indefinidamente. Observa que, aunque \
estos puntos est\[AAcute]n muy pr\[OAcute]ximos convergen a distintas ra\
\[IAcute]ces. No parece cosa f\[AAcute]cil entender este comportamiento. La \
frontera del conjunto que estamos representando tiene una ",
  StyleBox["estructura fractal",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Tambi\[EAcute]n es una buena imagen de lo que se llama ",
  StyleBox["caos matem\[AAcute]tico",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " porque muestra que peque\[NTilde]\[IAcute]simos cambios en los valores \
iniciales conducen a soluciones completamente diferentes."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Los conjuntos de Julia y de Mandelbrot", "Section"],

Cell[TextData[{
  "Los fractales m\[AAcute]s conocidos son los conjuntos de Julia y de \
Mandelbrot. Es muy f\[AAcute]cil generar dichos conjuntos usando \
n\[UAcute]meros complejos. Para cada n\[UAcute]mero complejo ",
  Cell[BoxData[
      FormBox[
        StyleBox["c",
          FontWeight->"Bold"], TraditionalForm]]],
  " definamos la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(f\_c\) : \[DoubleStruckCapitalC]\[LongRightArrow]\
\[DoubleStruckCapitalC]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(f\_c\)(z) = z\^2 + c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " para todo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\  \[Element] \ \[DoubleStruckCapitalC]\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". El",
  StyleBox[" conjunto de Julia",
    FontWeight->"Bold"],
  "  asociado al n\[UAcute]mero complejo ",
  Cell[BoxData[
      FormBox[
        StyleBox["c",
          FontWeight->"Bold"], TraditionalForm]]],
  " se define como el conjunto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " de los n\[UAcute]meros complejos ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " tales que la sucesi\[OAcute]n definida por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_0 = z, \ 
          z\_n = \(z\_\(n - 1\)\%2 + c = \(f\_c\)(z\_n)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " est\[AAcute] acotada (algunos autores llaman conjunto de Julia",
  StyleBox[" a la frontera",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "). El conjunto de Mandelbrot es el conjunto de los n\[UAcute]meros \
complejos ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " tales que la sucesi\[OAcute]n definida por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_0 = 0, \ 
          z\_n = \(z\_\(n - 1\)\%2 + z = \(f\_z\)(z\_n)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " est\[AAcute] acotada. En otros t\[EAcute]rminos, el conjunto de \
Mandelbrot es el conjunto de los n\[UAcute]meros complejos ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " tales que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(0 \[Element] J(z)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". \nPara representar la sucesi\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_0 = z, \ 
          z\_n = \(z\_\(n - 1\)\%2 + c = \(f\_c\)(z\_n)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " suele usarse la notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_n = \(f\_c\%\((n)\)\)(z)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", con el convenio de que ",
  Cell[BoxData[
      \(TraditionalForm\`z\_0 = \(\(f\_c\%\((0)\)\)(z) = z\)\)],
    FontWeight->"Bold"],
  ". Esta sucesi\[OAcute]n se llama la ",
  StyleBox["\[OAcute]rbita",
    FontWeight->"Bold"],
  " de ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y sus elementos se obtienen iterando sucesivamente la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " partiendo del valor inicial ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  ". La notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\%\((n)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "representa la composici\[OAcute]n de la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " consigo misma ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " veces."
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 1",
    FontWeight->"Bold"],
  " Describe el conjunto de Julia correspondiente a ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(c = 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 2",
    FontWeight->"Bold"],
  " Prueba que si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(z\)\(|\)\(\(\[GreaterEqual]\)\(\(|\)\(c\)\(|\)\(\(>\
\)\(2\)\)\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox["z",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox["\[NotElement]",
              FontWeight->"Bold"], 
            StyleBox[\(J(c)\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 3 ",
    FontWeight->"Bold"],
  "Prueba que si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(z\)\(|\)\(\(>\)\(2\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " no est\[AAcute] en el conjunto de Mandelbrot. Deduce que si ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " est\[AAcute] en el conjunto de Mandelbrot entonces ",
  StyleBox["todos",
    FontSlant->"Italic"],
  " los t\[EAcute]rminos de la sucesi\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\_1 = 0, \ z\_\(n + 1\) = z\_n\%2 + z\),
          FontWeight->"Bold"], TraditionalForm]]],
  " est\[AAcute]n en ",
  "el disco ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(z\)\(|\)\(\(\[LessEqual]\)\(2\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 4",
    FontWeight->"Bold"],
  " Prueba que el disco ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(z\)\(|\)\(\(\[LessEqual]\)\(1/4\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " est\[AAcute] contenido en el conjunto de Mandelbrot."
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 5",
    FontWeight->"Bold"],
  " Si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(\(f\_c\%\((n)\)\)(
              z)\)\(|\)\(\(>\)\(max {\(\(|\)\(c\)\(|\)\), 2}\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " para alg\[UAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(n \[GreaterEqual] 0\),
          FontWeight->"Bold"], TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\  \[NotElement] J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". En particular, para ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(c\)\(|\)\(\(\[LessEqual]\)\(2\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`J(c)\)],
    FontWeight->"Bold"],
  " est\[AAcute] contenido ",
  "en ",
  "el disco ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(z\)\(|\)\(\(\[LessEqual]\)\(2\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  "Los conjuntos de Julia y de Mandelbrot se representan con facilidad. El \
siguiente c\[OAcute]digo procede de la revista  ",
  StyleBox["Mathematica Journal.",
    FontSlant->"Italic"],
  " "
}], "Text"],

Cell[BoxData[
    \(\(JuliaFunction = 
        Compile[{{z, _Complex}, {c, _Complex}}, 
          Module[{w, k = 0}, w = z; 
            While[Abs[w] \[LessEqual] 2.0\  && \ k \[LessEqual] 35, 
              w = w\^2 + c; k = k + 1]; k]\ ];\)\)], "Input"],

Cell[TextData[{
  "Este c\[OAcute]digo define una funci\[OAcute]n \"JuliaFunction[z,c]\" que \
calcula t\[EAcute]rminos de la \[OAcute]rbita de ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". El proceso se detiene si se encuentra un t\[EAcute]rmino de dicha \
\[OAcute]rbita con m\[OAcute]dulo mayor que 2 y en otro caso contin\[UAcute]a \
hasta calcular el t\[EAcute]rmino 35 de la sucesi\[OAcute]n. Observa que ",
  StyleBox["la salida de esta funci\[OAcute]n es",
    FontSlant->"Italic"],
  " ",
  StyleBox["el n\[UAcute]mero de iteraciones",
    FontSlant->"Italic"],
  " ",
  StyleBox["que realiza m\[AAcute]s una",
    FontSlant->"Italic"],
  ". Si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z \[Element] \ J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " entonces -JuliaFunction[z,c]=36, y si -JuliaFunction[z,c]<36 se tiene que \
",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\  \[NotElement] J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Es posible que para algunos valores \"raros\" de ",
  StyleBox["z",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " sean necesarias m\[AAcute]s de 35 iteraciones para saber si est\[AAcute]n \
o no en el conjunto de Julia, para tales valores podr\[IAcute]a ocurrir que",
  " Function[z,c]=36 pero ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\  \[NotElement] J(c)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". El conjunto de estos valores \"raros\" es tan peque\[NTilde]o que no \
afecta realmente al aspecto final del conjunto. "
}], "Text"],

Cell["\<\
Calculemos los valores de \"JuliaFunction[x+yI,-1]\" en cada uno de los \
puntos (x,y) del ret\[IAcute]culo siguiente.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlot[
        Flatten[Table[{x, y}, {y, \(-1.1\), 1.1,  .1}, {x, \(-1.5\), 
              1.5,  .1}], 1]];\)\)], "Input"],

Cell[BoxData[
    \(datos = 
      Table[JuliaFunction[x + y\ I, \(-1\)], {y, \(-1.1\), 
          1.1,  .1}, {x, \(-1.5\), 1.5,  .1}]\)], "Input"],

Cell[TextData[{
  "Podemos asignar un color a cada punto (x,y) seg\[UAcute]n cu\[AAcute]l sea \
el valor en dicho punto de la funci\[OAcute]n JuliaFunction[x+yI,-1]. Es \
importante que entiendas c\[OAcute]mo ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " asigna colores. Recuerda que la funci\[OAcute]n \"Hue\" es \
peri\[OAcute]dica con per\[IAcute]odo 1, es decir, Hue[x]=Hue[x+1]. Aqu\
\[IAcute] puedes ver c\[OAcute]mo asigna colores dicha funci\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(\(Show[
        Graphics[\(({Hue[#], Rectangle[{#, 0}, {#1 +  .1, 1}]} &)\) /@ 
            Range[0, 2.5,  .1], AspectRatio \[Rule] Automatic]];\)\)], "Input",\

  CellTags->"Hue"],

Cell[TextData[{
  " Usemos \"ListDensityPlot\" para representar la tabla de valores, que \
hemos llamado \"datos\", antes obtenida. Como el valor de \
JuliaFunction[x+yI,-1] es siempre un n\[UAcute]mero natural, se tiene que \
Hue[JuliaFunction[x+yI,-1]]=Hue[0]. Para evitar asignar a todos los puntos el \
mismo color,  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " hace una reducci\[OAcute]n a escala de los valores de la funci\[OAcute]n \
JuliaFunction[x+yI,-1] antes de aplicar la funci\[OAcute]n \"Hue\". \
Concretamente, en el caso que nos ocupa, el color que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " asigna al punto (x,y) es  Hue[JuliaFunction[x+yI,-1]/36]. Por ello los \
puntos en rojo est\[AAcute]n en el conjunto de Julia aunque tambi\[EAcute]n \
puntos alejados de dicho conjunto, por ejemplo aquellos en los que \
JuliaFunction[x+yI,-1]=1, se representan en un color rojizo pues Hue[1/36] es \
parecido a Hue[0]=Hue[1]. "
}], "Text"],

Cell[BoxData[
    \(\(ListDensityPlot[datos, ColorFunction \[Rule] Hue];\)\)], "Input"],

Cell["\<\
Observa la diferencia entre la gr\[AAcute]fica antes obtenida y la que sigue \
en la que hemos modificado la funci\[OAcute]n de color de forma que distinga \
mejor los puntos del conjunto de Julia.\
\>", "Text"],

Cell[BoxData[
    \(\(ListDensityPlot[datos, 
        ColorFunction \[Rule] \((Hue[
                If[# \[GreaterEqual] 7, #/36, #/12]] &)\), 
        ColorFunctionScaling \[Rule] False];\)\)], "Input"],

Cell[TextData[{
  "Hagamos lo mismo pero con ",
  StyleBox["m\[AAcute]s",
    FontSlant->"Italic"],
  " puntos. Es c\[OAcute]modo definir una funci\[OAcute]n \"datosjulia\" como \
sigue. "
}], "Text"],

Cell[BoxData[{
    \(\(Clear[datos];\)\), "\[IndentingNewLine]", 
    \(datosjulia[c_, inc_] := \(datosjulia[c, inc] = 
        Table[JuliaFunction[x + y\ I, c], {y, \(-1.1\), 1.1, 
            inc}, {x, \(-1.5\), 1.5, inc}]\)\)}], "Input"],

Cell["\<\
Ahora representamos datos[-1,0.005] (si tu ordenador es lento, o eres muy \
impaciente, sustituye el incremento 0.005 por 0.01).\
\>", "Text"],

Cell[BoxData[
    \(\(ListDensityPlot[datosjulia[\(-1\), 0.005], Frame \[Rule] False, 
        Mesh \[Rule] False, ColorFunction \[Rule] Hue, 
        AspectRatio \[Rule] 3/4, 
        PlotLabel \[Rule] 
          StyleForm["\<El conjunto de Julia generado por c=-1\>", 
            FontFamily \[Rule] Times, FontSize \[Rule] 14], 
        ImageSize \[Rule] {374, 250}];\)\)], "Input"],

Cell["\<\
Exactamente lo mismo puede conseguirse directamente con el comando \
\"DensityPlot\".\
\>", "Text"],

Cell[BoxData[
    \(\(DensityPlot[
        JuliaFunction[x + y\ I, \(-1\)], {x, \(-1.5\), 1.5}, {y, \(-1.1\), 
          1.1}, PlotPoints \[Rule] 500, ColorFunction \[Rule] Hue, 
        Mesh \[Rule] False, AspectRatio \[Rule] Automatic, 
        Frame \[Rule] False, 
        PlotLabel \[Rule] 
          StyleForm["\<El conjunto de Julia generado por c=-1\>", 
            FontFamily \[Rule] Times, FontSize \[Rule] 14], 
        ImageSize \[Rule] {374, 250}];\)\)], "Input"],

Cell[TextData[{
  "La ventaja de proceder como antes es que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " recuerda la lista \"datosjulia[-1,0.005]\" y, si queremos, podemos volver \
a representarla cambiando, por ejemplo, la funci\[OAcute]n de color sin \
necesidad de volver a obtener los datos. Compru\[EAcute]balo."
}], "Text"],

Cell[BoxData[
    \(\(ListDensityPlot[datosjulia[\(-1\), 0.005], Frame \[Rule] False, 
        Mesh \[Rule] False, 
        ColorFunction \[Rule] \((Hue[
                If[# \[LessEqual] \ 5, 1/\((2  #)\), 1/#]] &)\), 
        AspectRatio \[Rule] 1/GoldenRatio, 
        PlotLabel \[Rule] 
          StyleForm["\<El conjunto de Julia generado por c=-1\>", 
            FontFamily \[Rule] Times, FontSize \[Rule] 14], 
        ImageSize \[Rule] {374, 250}];\)\)], "Input"],

Cell[TextData[{
  "Te sugiero que representes los conjuntos de Julia para valores de ",
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " igual a ",
  StyleBox["-0.5, 0.360284 + 0.100376 \[ImaginaryI], -0.122 + 0.745 \
\[ImaginaryI]",
    FontWeight->"Bold"],
  " ."
}], "Text"],

Cell[BoxData[
    \(\(ListDensityPlot[datosjulia[0.360284\  + \ 0.100376\ I, 0.005], 
        Frame \[Rule] False, Mesh \[Rule] False, 
        ColorFunction \[Rule] \((Hue[If[# == 36, #, 1/\((# +  .1)\)]] &)\), 
        AspectRatio \[Rule] 2/3, 
        PlotLabel \[Rule] 
          StyleForm["\<El conjunto de Julia generado por c=0.3060284+0.100376 \
\[ImaginaryI]\>", FontFamily \[Rule] Times, FontSize \[Rule] 14], 
        ImageSize \[Rule] {374, 250}];\)\)], "Input"],

Cell["El siguiente c\[OAcute]digo genera el conjunto de Mandelbrot.", "Text"],

Cell[BoxData[
    \(\(MandelbrotFunction = 
        Compile[{{z, _Complex}}, 
          Module[{w, k = 0}, w = z; 
            While[Abs[w] \[LessEqual] 2.0\  && \ k \[LessEqual] 50, 
              w = w\^2 + z; k = k + 1]; k]\ ];\)\)], "Input"],

Cell["\<\
Te recuerdo otra vez que si tu ordenador es lento, o eres muy impaciente, \
sustituye el incremento 0.005 por 0.01  antes de evaluar la siguiente \
celda.\
\>", "Text"],

Cell[BoxData[
    \(\(datosmandelbrot = 
        Table[MandelbrotFunction[x\  + \ y\ I], \ {y, \(-1.15\), 
            1.15,  .005}, {x, \(-2.0\), 0.55,  .005}];\)\)], "Input"],

Cell[BoxData[
    \(\(ListDensityPlot[datosmandelbrot, Mesh \[Rule] False, 
        Frame \[Rule] False, ColorFunction \[Rule] Hue, 
        PlotLabel \[Rule] 
          StyleForm["\<El conjunto de Mandelbrot\>", 
            FontFamily \[Rule] Times, FontSize \[Rule] 14], 
        ImageSize \[Rule] {341, 341}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fractales maravillosos", "Section"],

Cell["\<\
Cambiemos la funci\[OAcute]n de color para ver su efecto en el conjunto de \
Mandelbrot.\
\>", "Text"],

Cell[BoxData[
    \(\(ListDensityPlot[datosmandelbrot, Mesh \[Rule] False, 
        Frame \[Rule] False, 
        ColorFunction \[Rule] \((Hue[If[# == 36, #, 1/\((# +  .1)\)]] &)\), 
        PlotLabel \[Rule] 
          StyleForm["\<El conjunto de Mandelbrot\>", 
            FontFamily \[Rule] Times, FontSize \[Rule] 14], 
        ImageSize \[Rule] {341, 341}];\)\)], "Input"],

Cell["\<\
Con una peque\[NTilde]a modificaci\[OAcute]n en los c\[OAcute]digos \
anteriores puedes conseguir gr\[AAcute]ficos sorprendentes. La modificaci\
\[OAcute]n consiste en pedirle a la funci\[OAcute]n que nos devuelva el m\
\[OAcute]dulo del valor de la \[UAcute]ltima iteraci\[OAcute]n.\
\>", "Text"],

Cell[BoxData[
    \(\(JuliaFunctionNew = 
        Compile[{{z, _Complex}, {c, _Complex}}, 
          Module[{w, k = 0}, w = z; 
            While[Abs[w] \[LessEqual] 2.0\  && \ k \[LessEqual] 35, 
              w = w\^2 + c; k = k + 1]; Abs[w]]\ ];\)\)], "Input"],

Cell[BoxData[
    \(datosjulianew[c_, inc_] := \(datosjulianew[c, inc] = 
        Table[JuliaFunctionNew[x + y\ I, c], {y, \(-1.5\), 1.5, 
            inc}, {x, \(-1.3\), 1.3, inc}]\)\)], "Input"],

Cell[BoxData[
    \(\(ListDensityPlot[datosjulianew[0.360284\  + \ 0.100376\ I, 0.005], 
        Frame \[Rule] False, Mesh \[Rule] False, ColorFunction \[Rule] Hue, 
        AspectRatio \[Rule] 2\/3, 
        PlotLabel \[Rule] 
          StyleForm["\<El conjunto de Julia generado por c=0.360284+0.100376\
\[ImaginaryI]\>", FontFamily \[Rule] Times, FontSize \[Rule] 14], 
        ImageSize \[Rule] {374, 250}];\)\)], "Input"],

Cell[BoxData[
    \(\(MandelbrotFunctionNew = 
        Compile[{{z, _Complex}}, 
          Module[{w, k = 0}, w = z; 
            While[Abs[w] \[LessEqual] 2.0\  && \ k \[LessEqual] 50, 
              w = w\^2 + z; k = k + 1]; Abs[w]]\ ];\)\)], "Input"],

Cell[BoxData[
    \(\(datosmandelbrotnew = 
        Table[MandelbrotFunctionNew[x\  + \ y\ I], {y, \(-1.15\), 1.15, 
            0.005}, {x, \(-2.0\), 0.55, 0.005}];\)\)], "Input"],

Cell[BoxData[
    \(\(ListDensityPlot[datosmandelbrotnew, Mesh \[Rule] False, 
        Frame \[Rule] False, ColorFunction \[Rule] Hue, 
        PlotLabel \[Rule] 
          StyleForm["\<El conjunto de Mandelbrot\>", 
            FontFamily \[Rule] Times, FontSize \[Rule] 14], 
        ImageSize \[Rule] {341, 341}];\)\)], "Input"],

Cell["Observa el efecto de un cambio en la funci\[OAcute]n de color.", "Text"],

Cell[BoxData[
    \(\(ListDensityPlot[datosmandelbrotnew, Mesh \[Rule] False, 
        Frame \[Rule] False, ColorFunction -> \((Hue[Exp[\(-#\)]] &)\), 
        PlotLabel \[Rule] 
          StyleForm["\<El conjunto de Mandelbrot\>", 
            FontFamily \[Rule] Times, FontSize \[Rule] 14], 
        ImageSize \[Rule] {341, 341}];\)\)], "Input"],

Cell[TextData[{
  "Para terminar, volvamos al comienzo pero sustituyendo el polinomio ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\^3 + 1\),
          FontWeight->"Bold"], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z\^5 + 1\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y cambiando un poco el c\[OAcute]digo."
}], "Text"],

Cell[BoxData[
    \(\(NewtonAproxNew = 
        Compile[{{z, _Complex}}, \[IndentingNewLine]Module[{w, k = 0}, 
            w = z; \[IndentingNewLine]While[
              Abs[w\^5 + 1] > 0.001\  && \ k \[LessEqual] 50\  && \ 
                w \[NotEqual] 0, w = \(\(-1\) + 4  w\^5\)\/\(5\ w\^4\); 
              k = k + 1]; k]];\)\)], "Input"],

Cell[BoxData[
    \(\(datospolinomionew = 
        Table[NewtonAproxNew[x\  + \ y\ \[ImaginaryI]], {y, \(-2\), 
            2,  .00345}, {x, \(-2\), 2,  .00877}];\)\)], "Input"],

Cell[BoxData[
    \(\(ListDensityPlot[datospolinomionew, Mesh \[Rule] False, 
        Frame \[Rule] False, ColorFunction \[Rule] \((Hue[1 - #] &)\), 
        ImageSize \[Rule] {383, 383}];\)\)], "Input"],

Cell["\<\
\[DownExclamation]Qu\[EAcute] maravilla! \[DownQuestion]Qui\[EAcute]n ha \
dicho que las matem\[AAcute]ticas no son hermosas?\
\>", "Text"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{Cell[ 
        TextData[ {"Iteraciones complejas y fractales"}], "Header"], 
      Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}, {Cell[ 
        TextData[ {"Iteraciones complejas y fractales"}], "Header"], 
      Inherited, Inherited}},
PageFooters->{{Cell[ 
        TextData[ {"Dpto. An\[AAcute]lisis Matem\[AAcute]tico"}], "Header"], 
      Inherited, Cell[ 
        TextData[ {"Prof. Javier P\[EAcute]rez"}], "Header"]}, {Cell[ 
        TextData[ {"Dpto. An\[AAcute]lisis Matem\[AAcute]tico"}], "Header"], 
      Inherited, Cell[ 
        TextData[ {"Prof. Javier P\[EAcute]rez"}], "Header"]}},
CellLabelAutoDelete->True,
StyleDefinitions -> "DemoJPG.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Hue"->{
    Cell[27390, 835, 200, 5, 62, "Input",
      CellTags->"Hue"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Hue", 38857, 1137}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 115, 3, 143, "Title"],
Cell[1823, 55, 373, 11, 110, "Text",
  PageBreakBelow->False],

Cell[CellGroupData[{
Cell[2221, 70, 101, 1, 84, "Section"],
Cell[2325, 73, 1725, 49, 151, "Text"],
Cell[4053, 124, 72, 1, 43, "Input"],
Cell[4128, 127, 1208, 33, 81, "Text"],
Cell[5339, 162, 93, 1, 43, "Input"],
Cell[5435, 165, 389, 13, 52, "Text"],
Cell[5827, 180, 93, 1, 43, "Input"],
Cell[5923, 183, 131, 3, 33, "Text"],
Cell[6057, 188, 395, 8, 124, "Input"],
Cell[6455, 198, 1132, 31, 106, "Text"],
Cell[7590, 231, 366, 10, 51, "Text"],
Cell[7959, 243, 172, 4, 43, "Input"],
Cell[8134, 249, 56, 0, 33, "Text"],
Cell[8193, 251, 44, 1, 42, "Input"],
Cell[8240, 254, 1930, 56, 119, "Text"],
Cell[10173, 312, 333, 7, 79, "Input"],
Cell[10509, 321, 116, 3, 33, "Text"],
Cell[10628, 326, 134, 3, 42, "Input"],
Cell[10765, 331, 1329, 36, 126, "Text"],
Cell[12097, 369, 669, 11, 142, "Input"],
Cell[12769, 382, 909, 29, 70, "Text"],
Cell[13681, 413, 147, 3, 42, "Input"],
Cell[13831, 418, 1079, 22, 131, "Text"],
Cell[14913, 442, 234, 4, 62, "Input"],
Cell[15150, 448, 76, 0, 33, "Text"],
Cell[15229, 450, 237, 4, 62, "Input"],
Cell[15469, 456, 123, 3, 33, "Text"],
Cell[15595, 461, 247, 4, 62, "Input"],
Cell[15845, 467, 689, 14, 89, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16571, 486, 57, 0, 84, "Section"],
Cell[16631, 488, 4238, 133, 216, "Text"],
Cell[20872, 623, 249, 9, 34, "Text"],
Cell[21124, 634, 713, 25, 34, "Text"],
Cell[21840, 661, 1012, 33, 52, "Text"],
Cell[22855, 696, 310, 9, 34, "Text"],
Cell[23168, 707, 1048, 36, 52, "Text"],
Cell[24219, 745, 222, 6, 51, "Text"],
Cell[24444, 753, 255, 5, 64, "Input"],
Cell[24702, 760, 1751, 47, 142, "Text"],
Cell[26456, 809, 142, 3, 33, "Text"],
Cell[26601, 814, 147, 3, 42, "Input"],
Cell[26751, 819, 147, 3, 42, "Input"],
Cell[26901, 824, 486, 9, 69, "Text"],
Cell[27390, 835, 200, 5, 62, "Input",
  CellTags->"Hue"],
Cell[27593, 842, 977, 18, 141, "Text"],
Cell[28573, 862, 87, 1, 42, "Input"],
Cell[28663, 865, 221, 4, 51, "Text"],
Cell[28887, 871, 203, 4, 42, "Input"],
Cell[29093, 877, 200, 6, 33, "Text"],
Cell[29296, 885, 240, 4, 82, "Input"],
Cell[29539, 891, 152, 3, 33, "Text"],
Cell[29694, 896, 385, 7, 102, "Input"],
Cell[30082, 905, 109, 3, 33, "Text"],
Cell[30194, 910, 477, 9, 102, "Input"],
Cell[30674, 921, 343, 7, 51, "Text"],
Cell[31020, 930, 472, 9, 102, "Input"],
Cell[31495, 941, 298, 10, 35, "Text"],
Cell[31796, 953, 474, 8, 102, "Input"],
Cell[32273, 963, 77, 0, 33, "Text"],
Cell[32353, 965, 245, 5, 84, "Input"],
Cell[32601, 972, 178, 4, 51, "Text"],
Cell[32782, 978, 176, 3, 42, "Input"],
Cell[32961, 983, 328, 6, 82, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33326, 994, 41, 0, 84, "Section"],
Cell[33370, 996, 112, 3, 33, "Text"],
Cell[33485, 1001, 378, 7, 102, "Input"],
Cell[33866, 1010, 307, 5, 51, "Text"],
Cell[34176, 1017, 263, 5, 64, "Input"],
Cell[34442, 1024, 196, 3, 62, "Input"],
Cell[34641, 1029, 426, 7, 118, "Input"],
Cell[35070, 1038, 253, 5, 84, "Input"],
Cell[35326, 1045, 180, 3, 62, "Input"],
Cell[35509, 1050, 331, 6, 82, "Input"],
Cell[35843, 1058, 78, 0, 33, "Text"],
Cell[35924, 1060, 347, 6, 82, "Input"],
Cell[36274, 1068, 381, 12, 33, "Text"],
Cell[36658, 1082, 344, 6, 100, "Input"],
Cell[37005, 1090, 177, 3, 42, "Input"],
Cell[37185, 1095, 203, 3, 62, "Input"],
Cell[37391, 1100, 149, 3, 33, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

